/*******************************************************************************
+
+	cluster_random.cc
+
+   Copyright (C) 2000
+	Kevin Pulo, kev@hons.cs.usyd.edu.au.
+	Garrick Welsh, gaz@hons.cs.usyd.edu.au.
+
+	This program is free software; you can redistribute it and/or modify
+	it under the terms of the GNU General Public License as published by
+	the Free Software Foundation; either version 2 of the License, or
+	(at your option) any later version.
+
+	This program is distributed in the hope that it will be useful,
+	but WITHOUT ANY WARRANTY; without even the implied warranty of
+	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+	GNU General Public License for more details.
+
+	You should have received a copy of the GNU General Public License
+	along with this program; if not, write to the Free Software
+	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
+
+	$Id: cluster_random.cc,v 1.4 2000/05/28 11:31:19 kev Exp kev $
+
*******************************************************************************/

#include "cluster_random.hh"


static const char *rcsid = "$Id: cluster_random.cc,v 1.4 2000/05/28 11:31:19 kev Exp kev $";
static const char *rcsrevision = "$Revision: 1.4 $";


void cluster_random(int k) {
	list<point> L = T.points();
	int n = L.length();
	point p;
	int i;
	int destClust;


	// Shuffle the list of points.
	L.permute();

	// Create k clusters.
	if (k < 1) {
		k = 1;
	}
	clusters.resize(k);

	// Loop through the list of points, putting the first n/k into the first
	// cluster, the next n/k into the next cluster, and so on.
	destClust = 0;
	i = 0;
	forall(p, L) {
		destClust = (int)((double)i/(double)n*(double)k);
		clusters[destClust].append(p);
		i++;
	}

	// Find the representatives of the clusters.
	for (i = clusters.low(); i <= clusters.high(); i++) {
		clusters[i].rep = clusters[i].meanPoint();
	}
}


