
// SimParm: Simple and flexible C++ configuration framework
// Copyright (C) 2007 Australian National University
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// Contact:
// Kevin Pulo
// kevin.pulo@anu.edu.au
// Leonard Huxley Bldg 56
// Australian National University, ACT, 0200, Australia

#include "ConfigSetOutputTabulated.hh"
#include "ConfigEntry.hh"

const string ConfigSetOutputTabulated::default_field_delim = "\t";
const string ConfigSetOutputTabulated::default_record_delim = "\n";
const string ConfigSetOutputTabulated::default_record_prefix_header = "# ";
const string ConfigSetOutputTabulated::default_record_prefix_normal = "";

ConfigSetOutputTabulated::ConfigSetOutputTabulated(const ConfigSet &configSet, string field_delim, string record_delim, string record_prefix, bool header)
: configSet(configSet), field_delim(field_delim), record_delim(record_delim), record_prefix(record_prefix), header(header)
{
}

ConfigSetOutputTabulated ConfigSetOutputTabulated::HeaderLine(const ConfigSet &configSet) {
	return ConfigSetOutputTabulated(configSet, default_field_delim, default_record_delim, default_record_prefix_header, true);
}

ConfigSetOutputTabulated ConfigSetOutputTabulated::HeaderLine(const ConfigSet &configSet, string field_delim) {
	return ConfigSetOutputTabulated(configSet, field_delim, default_record_delim, default_record_prefix_header, true);
}

ConfigSetOutputTabulated ConfigSetOutputTabulated::HeaderLine(const ConfigSet &configSet, string field_delim, string record_delim) {
	return ConfigSetOutputTabulated(configSet, field_delim, record_delim, default_record_prefix_header, true);
}

ConfigSetOutputTabulated ConfigSetOutputTabulated::HeaderLine(const ConfigSet &configSet, string field_delim, string record_delim, string record_prefix) {
	return ConfigSetOutputTabulated(configSet, field_delim, record_delim, record_prefix, true);
}

ConfigSetOutputTabulated ConfigSetOutputTabulated::NormalLine(const ConfigSet &configSet) {
	return ConfigSetOutputTabulated(configSet, default_field_delim, default_record_delim, default_record_prefix_normal, false);
}

ConfigSetOutputTabulated ConfigSetOutputTabulated::NormalLine(const ConfigSet &configSet, string field_delim) {
	return ConfigSetOutputTabulated(configSet, field_delim, default_record_delim, default_record_prefix_normal, false);
}

ConfigSetOutputTabulated ConfigSetOutputTabulated::NormalLine(const ConfigSet &configSet, string field_delim, string record_delim) {
	return ConfigSetOutputTabulated(configSet, field_delim, record_delim, default_record_prefix_normal, false);
}

ConfigSetOutputTabulated ConfigSetOutputTabulated::NormalLine(const ConfigSet &configSet, string field_delim, string record_delim, string record_prefix) {
	return ConfigSetOutputTabulated(configSet, field_delim, record_delim, record_prefix, false);
}

ostream& operator<<(ostream& out, const ConfigSetOutputTabulated &configSetOutputTabulated) {
	const ConfigSet &configSet = configSetOutputTabulated.configSet;

	if (configSet.ordered.size() > 0) {
		out << configSetOutputTabulated.record_prefix;
		for (vector<ConfigEntry*>::const_iterator entry = configSet.ordered.begin(); entry != configSet.ordered.end(); entry++) {
			if (configSetOutputTabulated.header) {
				out << (*entry)->name();
			} else {
				(*entry)->output_value(out);
			}
			if (entry + 1 != configSet.ordered.end()) {
				out << configSetOutputTabulated.field_delim;
			}
		}
		out << configSetOutputTabulated.record_delim;
	}

	return out;
}

